﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;
using System.Reflection;

namespace VIRP.CRS.BLL
{
    public static partial class VIRPManager
    {
        #region BCCCR_BCR_ALL

        public static List<BCCCR_BCR_ALL> BCCCR_BCR_ALL_GET_ALL_BY_SEARCH(string identity, int registryId, short sta3n, string patientSearch)
        {
            return BCCCR_BCR_ALLManager.GetItemsBySearch(identity, registryId, sta3n, patientSearch);
        }

        #endregion

        #region DATA_DICTIONARY

        public static List<DATA_DICTIONARY> DATA_DICTIONARY_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return DATA_DICTIONARYManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        #endregion

        #region DB_LOG

        public static int DB_LOG_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, DB_LOG objSave)
        {
            return DB_LOGManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        #endregion

        #region ETL_ExtractBatch_Log

        public static List<ETL_ExtractBatch_Log> ETL_ExtractBatch_Log_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return ETL_ExtractBatch_LogManager.GetItemsByRegistry(identity, registryId);
        }

        #endregion

        #region PATIENT

        public static PATIENT PATIENT_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return PATIENTManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static PATIENT PATIENT_GET_COMPLETE(string identity, int registryId, int patientId)
        {
            return PATIENTManager.GetItemComplete(identity, registryId, patientId);
        }

        public static List<PATIENT> PATIENT_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return PATIENTManager.GetItemsByRegistry(identity, registryId);
        }

        public static List<PATIENT> PATIENT_GET_ALL_BY_NAME(string identity, int registryId, string lastName, string firstName)
        {
            return PATIENTManager.GetItemsByName(identity, registryId, lastName, firstName);
        }

        #endregion

        #region PATIENT_UDFs

        public static int PATIENT_UDFs_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, PATIENT_UDFs objSave)
        {
            return PATIENT_UDFsManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static PATIENT_UDFs PATIENT_UDFs_GET_BY_PATIENT_UDF(string identity, int registryId, int patientId, int udfId)
        {
            return PATIENT_UDFsManager.GetItemByPatientUdf(identity, registryId, patientId, udfId);
        }

        #endregion

        #region REFERRAL

        public static REFERRAL REFERRAL_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return REFERRALManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int REFERRAL_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, REFERRAL objSave)
        {
            return REFERRALManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean REFERRAL_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return REFERRALManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static REFERRAL REFERRAL_GET_COMPLETE(string identity, int registryId, int referralId)
        {
            return REFERRALManager.GetItemComplete(identity, registryId, referralId);
        }

        public static List<REFERRAL> REFERRAL_GET_ALL_BY_REGISTRY_STATUS(string identity, int registryId, int statusId)
        {
            return REFERRALManager.GetItemsByRegistryStatus(identity, registryId, statusId);
        }

        public static REFERRALcommonGroup REFERRAL_GET_COMMON_BY_REGISTRY(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, int PATIENT_ID, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS, bool IsPatientList)
        {
            return REFERRALManager.GetItemsCommonByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS, IsPatientList);
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_REGISTRY(string identity, int registryId)
        {
            return REFERRALManager.GetItemsCommonByRegistry(identity, registryId);
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PATIENT(string identity, int registryId, int patientId)
        {
            return REFERRALManager.GetItemsCommonByPatient(identity, registryId, patientId);
        }

        public static List<REFERRALcommon> REFERRAL_GET_COMMON_BY_PROVIDER(string identity, int registryId, int providerId)
        {
            return REFERRALManager.GetItemsCommonByProvider(identity, registryId, providerId);
        }

        public static bool REFERRAL_PATIENT_EXISTS(string identity, int registryId, int patientId)
        {
            return REFERRALManager.CheckPatientExists(identity, registryId, patientId);
        }

        public static int REFERRAL_SAVE_MANUAL(string identity, int registryId, int patientId, int providerId)
        {
            return REFERRALManager.SaveManual(identity, registryId, patientId, providerId);
        }

        public static bool REFERRAL_UPDATE_STATUS(string identity, int registryId, int referralId, int statusId)
        {
            return REFERRALManager.UpdateStatus(identity, registryId, referralId, statusId);
        }

        #endregion

        #region REGISTRY_COHORT_DATA

        public static List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return REGISTRY_COHORT_DATAManager.GetItemsByRegistry(identity, registryId);
        }

        public static List<REGISTRY_COHORT_DATA> REGISTRY_COHORT_DATA_GET_ALL_SELECTED_BY_REGISTRY(string identity, int registryId)
        {
            return REGISTRY_COHORT_DATAManager.GetItemsSelectedByRegistry(identity, registryId);
        }

        public static bool REGISTRY_COHORT_DATA_SAVE_LIST(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return REGISTRY_COHORT_DATAManager.SaveList(identity, registryId, cohorts);
        }

        public static int REGISTRY_COHORT_DATA_GET_PREVIEW_COUNT(string identity, int registryId, List<REGISTRY_COHORT_DATA> cohorts)
        {
            return REGISTRY_COHORT_DATAManager.GetPreviewCount(identity, registryId, cohorts);
        }

        #endregion

        #region REGISTRY_CORE_DATA

        public static REGISTRY_CORE_DATA REGISTRY_CORE_DATA_GET_BY_REGISTRY_CORE(string identity, int registryId, int CORE_TYPE_ID)
        {
            return REGISTRY_CORE_DATAManager.GetItemByRegistryCore(identity, registryId, CORE_TYPE_ID);
        }

        public static List<REGISTRY_CORE_DATA> REGISTRY_CORE_DATA_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return REGISTRY_CORE_DATAManager.GetItemsByRegistry(identity, registryId);
        }

        public static bool REGISTRY_CORE_DATA_SAVE_LIST(string identity, int registryId, List<REGISTRY_CORE_DATA> cores)
        {
            return REGISTRY_CORE_DATAManager.SaveList(identity, registryId, cores);
        }

        #endregion

        #region SETTINGS

        public static bool SETTINGS_SAVE_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID, AppSettings objSave)
        {
            return SETTINGSManager.SaveAll(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static int SETTINGS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SETTINGS objSave)
        {
            return SETTINGSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static SETTINGS SETTINGS_GET_REGISTRYNAME(string identity, int registryId, string registryName)
        {
            return SETTINGSManager.GetItemByRegistryName(identity, registryId, registryName);
        }

        public static SETTINGS SETTINGS_GET_HOME_PAGE()
        {
            return SETTINGSManager.GetItemHomePage();
        }

        #endregion

        #region SStaff_SStaff

        public static SStaff_SStaff SStaff_SStaff_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SStaff_SStaffManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return SStaff_SStaffManager.GetItemsByRegistry(identity, registryId);
        }

        public static int SStaff_SStaff_GET_ALL_BY_REGISTRY_COUNT(string identity, int registryId, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION)
        {
            return SStaff_SStaffManager.GetItemsByRegistry(identity, registryId, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, 0, Int32.MaxValue).Count();
        }

        public static List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_REGISTRY(string identity, int registryId, string SEARCH_COLUMN, string SEARCH_TEXT, string SORT_EXPRESSION, int START_ROW, int MAX_ROWS)
        {
            return SStaff_SStaffManager.GetItemsByRegistry(identity, registryId, SEARCH_COLUMN, SEARCH_TEXT, SORT_EXPRESSION, START_ROW, MAX_ROWS);
        }

        public static List<SStaff_SStaff> SStaff_SStaff_GET_ALL_BY_NAME(string identity, int registryId, string lastName, string firstName)
        {
            return SStaff_SStaffManager.GetItemsByName(identity, registryId, lastName, firstName);
        }

        #endregion

        #region STD_INSTITUTION

        public static STD_INSTITUTION STD_INSTITUTION_GET_COMPLETE(string identity, int registryId, int id)
        {
            return STD_INSTITUTIONManager.GetItemComplete(identity, registryId, id);
        }

        public static List<STD_INSTITUTION> STD_INSTITUTION_GET_FACS(string identity, int registryId)
        {
            return STD_INSTITUTIONManager.GetFacs(identity, registryId);
        }

        #endregion

        #region STD_MENU_ITEMS

        public static STD_MENU_ITEMS STD_MENU_ITEMS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MENU_ITEMSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_MENU_ITEMS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_MENU_ITEMS objSave)
        {
            return STD_MENU_ITEMSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_MENU_ITEMS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_MENU_ITEMSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return STD_MENU_ITEMSManager.GetItemsByRegistry(identity, registryId);
        }

        public static List<STD_MENU_ITEMS> STD_MENU_ITEMS_GET_MENU(string identity, int registryId, string path)
        {
            return STD_MENU_ITEMSManager.GetMenu(identity, registryId, path);
        }

        #endregion

        #region STD_QUESTION

        public static STD_QUESTION STD_QUESTION_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_QUESTIONManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_QUESTION_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_QUESTION objSave)
        {
            return STD_QUESTIONManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_QUESTION_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_QUESTIONManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_QUESTION> STD_QUESTION_GET_ALL_BY_SURVEY(string identity, int registryId, int surveyTypeId)
        {
            return STD_QUESTIONManager.GetItemsBySurvey(identity, registryId, surveyTypeId);
        }

        public static Boolean STD_QUESTION_COPY_CHOICES(string identity, int registryId, int oldQuestionId, int newQuestionId)
        {
            return STD_QUESTIONManager.CopyChoices(identity, registryId, oldQuestionId, newQuestionId);
        }

        #endregion

        #region STD_QUESTION_CHOICE

        public static STD_QUESTION_CHOICE STD_QUESTION_CHOICE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_QUESTION_CHOICEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_QUESTION_CHOICE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_QUESTION_CHOICE objSave)
        {
            return STD_QUESTION_CHOICEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_QUESTION_CHOICE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_QUESTION_CHOICEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_QUESTION_CHOICE> STD_QUESTION_CHOICE_GET_ALL_BY_QUESTION(string identity, int registryId, int questionId)
        {
            return STD_QUESTION_CHOICEManager.GetItemsByQuestion(identity, registryId, questionId);
        }

        #endregion

        #region STD_REFERRALSTS

        public static STD_REFERRALSTS STD_REFERRALSTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return STD_REFERRALSTSManager.GetItemByCode(identity, registryId, code);
        }

        #endregion

        #region STD_REG_UDFs

        public static STD_REG_UDFs STD_REG_UDFs_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_REG_UDFsManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_REG_UDFs_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_REG_UDFs objSave)
        {
            return STD_REG_UDFsManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_REG_UDFs_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_REG_UDFsManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_REG_UDFs> STD_REG_UDFs_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return STD_REG_UDFsManager.GetItemsByRegistry(identity, registryId);
        }

        #endregion

        #region STD_REGISTRY

        public static STD_REGISTRY STD_REGISTRY_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_REGISTRYManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_REGISTRYManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_REGISTRY_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_REGISTRY objSave)
        {
            return STD_REGISTRYManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_REGISTRY_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_REGISTRYManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_REGISTRY STD_REGISTRY_GET_COMPLETE(string identity, int registryId, int id)
        {
            return STD_REGISTRYManager.GetItemComplete(identity, registryId, id);
        }

        public static STD_REGISTRY STD_REGISTRY_GET_SYSTEM()
        {
            return STD_REGISTRYManager.GetSystemRegistry();
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_BY_USER(string identity, int registryId)
        {
            return STD_REGISTRYManager.GetItemsByUser(identity, registryId);
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM()
        {
            return STD_REGISTRYManager.GetNonSystemRegistries();
        }

        public static List<STD_REGISTRY> STD_REGISTRY_GET_ALL_NON_SYSTEM_BY_USER(string identity, int registryId)
        {
            return STD_REGISTRYManager.GetNonSystemRegistriesByUser(identity, registryId);
        }

        #endregion

        #region STD_ROLE

        public static STD_ROLE STD_ROLE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_ROLEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_SYSTEM_ROLES(string identity, int registryId)
        {
            return STD_ROLEManager.GetSystemRoles(identity, registryId);
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_REGISTRY_ROLES(string identity, int registryId)
        {
            return STD_ROLEManager.GetRegistryRoles(identity, registryId);
        }

        public static List<STD_ROLE> STD_ROLE_GET_ALL_BY_USER_REGISTRY(string identity, int registryId)
        {
            return STD_ROLEManager.GetItemsByUserRegistry(identity, registryId);
        }

        #endregion

        #region STD_SURVEY_TYPE

        public static STD_SURVEY_TYPE STD_SURVEY_TYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SURVEY_TYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_SURVEY_TYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_SURVEY_TYPE objSave)
        {
            return STD_SURVEY_TYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_SURVEY_TYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_SURVEY_TYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_SURVEY_TYPE> STD_SURVEY_TYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return STD_SURVEY_TYPEManager.GetItemsByRegistry(identity, registryId);
        }

        #endregion

        #region STD_WEB_PAGES

        public static STD_WEB_PAGES STD_WEB_PAGES_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WEB_PAGESManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WEB_PAGES> STD_WEB_PAGES_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return STD_WEB_PAGESManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int STD_WEB_PAGES_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WEB_PAGES objSave)
        {
            return STD_WEB_PAGESManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WEB_PAGES_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WEB_PAGESManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        #endregion

        #region STD_WKFACTIVITYSTS

        public static STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFACTIVITYSTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_WKFACTIVITYSTS STD_WKFACTIVITYSTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return STD_WKFACTIVITYSTSManager.GetItemByCode(identity, registryId, code);
        }

        #endregion

        #region STD_WKFACTIVITYTYPE

        public static STD_WKFACTIVITYTYPE STD_WKFACTIVITYTYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFACTIVITYTYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_WKFACTIVITYTYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WKFACTIVITYTYPE objSave)
        {
            return STD_WKFACTIVITYTYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WKFACTIVITYTYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFACTIVITYTYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return STD_WKFACTIVITYTYPEManager.GetItemsByRegistry(identity, registryId);
        }

        public static List<STD_WKFACTIVITYTYPE> STD_WKFACTIVITYTYPE_GET_ALL_BY_WORKSTREAM(string identity, int registryId, int streamId)
        {
            return STD_WKFACTIVITYTYPEManager.GetItemsByWorkstream(identity, registryId, streamId);
        }

        #endregion

        #region STD_WKFCASESTS

        public static STD_WKFCASESTS STD_WKFCASESTS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFCASESTSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static STD_WKFCASESTS STD_WKFCASESTS_GET_BY_CODE(string identity, int registryId, string code)
        {
            return STD_WKFCASESTSManager.GetItemByCode(identity, registryId, code);
        }

        #endregion

        #region STD_WKFCASETYPE

        public static STD_WKFCASETYPE STD_WKFCASETYPE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFCASETYPEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int STD_WKFCASETYPE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, STD_WKFCASETYPE objSave)
        {
            return STD_WKFCASETYPEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean STD_WKFCASETYPE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return STD_WKFCASETYPEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<STD_WKFCASETYPE> STD_WKFCASETYPE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return STD_WKFCASETYPEManager.GetItemsByRegistry(identity, registryId);
        }

        #endregion

        #region SURVEY_RESULTS

        public static List<SURVEY_RESULTS> SURVEY_RESULTS_GET_ALL_BY_SURVEY(string identity, int registryId, int surveyId)
        {
            return SURVEY_RESULTSManager.GetItemsBySurvey(identity, registryId, surveyId);
        }

        public static Boolean SURVEY_RESULTS_SAVE_ALL(string identity, int registryId, SURVEY_RESULTS[] results)
        {
            List<SURVEY_RESULTS> temp = null;
            if (results != null)
                temp = results.ToList();
            return SURVEY_RESULTSManager.SaveAll(identity, registryId, temp);
        }

        #endregion

        #region SURVEYS

        public static SURVEYS SURVEYS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SURVEYSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int SURVEYS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, SURVEYS objSave)
        {
            return SURVEYSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean SURVEYS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return SURVEYSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static SURVEYS SURVEYS_GET_FOR_SURVEY(string identity, int registryId, int surveysId)
        {
            return SURVEYSManager.GetItemForSurvey(identity, registryId, surveysId);
        }

        public static List<SURVEYS> SURVEYS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return SURVEYSManager.GetItemsByRegistry(identity, registryId);
        }

        #endregion

        #region USER_ROLES

        public static USER_ROLES USER_ROLES_GET_BY_USERID_ROLEID(string identity, int registryId, int userId, int roleId)
        {
            return USER_ROLESManager.GetItemByUserIdRoleId(identity, registryId, userId, roleId);
        }

        public static List<string> USER_ROLES_GET_BY_REGISTRYID_USERNAME(string username, int registryId)
        {
            return USER_ROLESManager.GetItemsByRegistryIdUsername(username, registryId);
        }

        public static USER_ROLES USER_ROLES_GET_BY_USER_ROLE(string username, string rolename)
        {
            return USER_ROLESManager.GetItemByUserRole(username, rolename);
        }

        public static string[] USER_ROLES_GET_ROLES(string username)
        {
            return USER_ROLESManager.GetRoles(username);
        }

        public static List<USER_ROLES> USER_ROLES_GET_ALL_BY_USER(string identity, int registryId, int userId)
        {
            return USER_ROLESManager.GetItemsByUser(identity, registryId, userId);
        }

        public static bool USER_ROLES_DELETE_BY_USER_REGISTRY(string identity, int registryId, int userId, int stdRegistryId)
        {
            return USER_ROLESManager.DeleteByUserRegistry(identity, registryId, userId, stdRegistryId);
        }

        public static bool USER_ROLES_SAVE_ALL(string identity, int registryId, USER_ROLES[] userRoles)
        {
            List<USER_ROLES> temp = null;
            if (userRoles != null)
                temp = userRoles.ToList();

            return USER_ROLESManager.SaveAll(identity, registryId, temp);
        }

        #endregion

        #region USERS

        public static USERS USERS_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return USERSManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<USERS> USERS_GET_ALL(string CURRENT_USER, int CURRENT_REGISTRY_ID)
        {
            return USERSManager.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);
        }

        public static int USERS_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, USERS objSave)
        {
            return USERSManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean USERS_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return USERSManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static USERS USERS_GET_BY_NAME(string identity, int registryId, string username)
        {
            return USERSManager.GetItemByName(identity, registryId, username);
        }

        public static bool USERS_DEFAULT_REGISTRY(string identity, int registryId, bool isDefault)
        {
            return USERSManager.SetDefaultRegistry(identity, registryId, isDefault);
        }

        public static DomainNames USERS_LOAD_FROM_AD()
        {
            return USERSManager.LoadFromActiveDirectory();
        }

        public static List<DomainUser> USERS_GET_ALL_BY_AD(DomainNames domainNames, string searchString)
        {
            return USERSManager.GetActiveDirectory(domainNames, searchString);
        }

        public static List<USERS> USERS_GET_ALL_BY_USER(string identity, int registryId)
        {
            return USERSManager.GetItemsByUser(identity, registryId);
        }

        #endregion

        #region WKF_CASE

        public static WKF_CASE WKF_CASE_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return WKF_CASEManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int WKF_CASE_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            return WKF_CASEManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean WKF_CASE_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return WKF_CASEManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<WKF_CASE> WKF_CASE_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return WKF_CASEManager.GetItemsByRegistry(identity, registryId);
        }

        public static bool WKF_CASE_UPDATE_STATUS(string identity, int registryId, int wkfCaseId, int statusId)
        {
            return WKF_CASEManager.UpdateStatus(identity, registryId, wkfCaseId, statusId);
        }

        #endregion

        #region WKF_CASE_ACTIVITY

        public static WKF_CASE_ACTIVITY WKF_CASE_ACTIVITY_GET(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return WKF_CASE_ACTIVITYManager.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static int WKF_CASE_ACTIVITY_SAVE(string CURRENT_USER, int CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY objSave)
        {
            return WKF_CASE_ACTIVITYManager.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);
        }

        public static Boolean WKF_CASE_ACTIVITY_DELETE(string CURRENT_USER, int CURRENT_REGISTRY_ID, int id)
        {
            return WKF_CASE_ACTIVITYManager.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, id);
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return WKF_CASE_ACTIVITYManager.GetItemsByRegistry(identity, registryId);
        }

        public static List<WKF_CASE_ACTIVITY> WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(string identity, int registryId, int wkfCaseId)
        {
            return WKF_CASE_ACTIVITYManager.GetItemsByWorkstream(identity, registryId, wkfCaseId);
        }

        public static bool WKF_CASE_ACTIVITY_UPDATE_STATUS(string identity, int registryId, int wkfCaseActivityId, int statusId)
        {
            return WKF_CASE_ACTIVITYManager.UpdateStatus(identity, registryId, wkfCaseActivityId, statusId);
        }

        #endregion

        #region LOGS

        public static void LOG_DETAILS(LogDetails logDetails)
        {
            LogManager.LogDetails(logDetails);
        }

        public static void LOG_TIMING(LogDetails logDetails)
        {
            LogManager.LogTiming(logDetails);
        }

        public static void LOG_INFORMATION(string message, string processName, string username, int registryId)
        {
            LogManager.LogInformation(message, processName, username, registryId);
        }

        public static void LOG_ERROR(string message, string processName, string username, int registryId)
        {
            LogManager.LogError(message, processName, username, registryId);
        }

        #endregion

        #region REPORTS

        public static List<ReportItem> REPORTS_GET_ALL_BY_USER_REGISTRY(string identity, int registryId)
        {
            return ReportManager.GetAllByUserAndRegistry(identity, registryId);
        }

        public static List<ReportItem> REPORTS_GET_ALL_BY_REGISTRY(string identity, int registryId)
        {
            return ReportManager.GetRegistryReports(identity, registryId);
        }

        public static List<ReportItem> REPORTS_GET_ALL_SYSTEM(string identity, int registryId)
        {
            return ReportManager.GetSystemReports(identity, registryId);
        }

        public static List<ReportItem> REPORTS_GET_ALL_BY_USER(string identity, int registryId)
        {
            return ReportManager.GetUserReports(identity, registryId);
        }

        public static bool REPORTS_UPDATE_ITEM_PROPERTIES(string identity, int registryId, string itemPath, string description)
        {
            return ReportManager.UpdateItemProperties(identity, registryId, itemPath, description);
        }

        #endregion

        #region MVI

        public static bool PRPA_IN201305UV02(string identity, int registryId, int patientId, int mviTypeId)
        {
            return MviManager.PRPA_IN201305UV02(identity, registryId, patientId, mviTypeId);
        }

        public static bool PRPA_IN201309UV02(string identity, int registryId, int patientId)
        {
            return MviManager.PRPA_IN201309UV02(identity, registryId, patientId);
        }

        #endregion

        #region ETL

        public static int ETL_UPDATE_REGISTRY_COHORT(string identity, int registryId)
        {
            return ETLManager.UpdateRegistryCohort(identity, registryId);
        }

        public static int ETL_PREVIEW_REGISTRY_COHORT(string identity, int registryId)
        {
            return ETLManager.PreviewRegistryCohort(identity, registryId);
        }

        #endregion

        public static List<ENC_ENCOUNTER> ENC_ENCOUNTER_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return ENC_ENCOUNTERManager.GetItemsByReferral(identity, registryId, referralId);
        }

        public static List<OUTPAT_VISIT> OUTPAT_VISIT_GET_BY_REFERRAL(string identity, int registryId, int referralId)
        {
            return OUTPAT_VISITManager.GetItemsByReferral(identity, registryId, referralId);
        }

        public static string GET_VERSION()
        {
            string buildVersion = "n/a";

            Assembly assembly = Assembly.GetExecutingAssembly();
            string[] assemblyInfo = assembly.FullName.Split(',');
            foreach (string info in assemblyInfo)
            {
                if (info.Contains("Version="))
                {
                    buildVersion = info.Split('=')[1];
                    break;
                }
            }

            return buildVersion;
        }
    }
}
